package gov.va.vinci.dart.json;

import java.util.List;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class ModifyReviewGroupsView {
	
	@Min(0)
	private int userId;
	
	@Min(0)
	private int requestId;
	
	private List<Integer> reviewsToBeRemoved;
	
	private List<Integer> reviewsToBeAdded;
	
	@Min(0)
	private int workflowId = 0;
	
	@NotNull
	@Size(min=1)
	private String inputMessage;
	
	   @NotNull
	    @Size(min=1)
	    private String inputTopic;

	
	public int getUserId() {
		return userId;
	}

	public void setUserId(int userId) {
		this.userId = userId;
	}


	public int getRequestId() {
        return requestId;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

	public String getInputMessage() {
        return inputMessage;
    }

    public void setInputMessage(String inputMessage) {
        this.inputMessage = inputMessage;
    }

    public String getInputTopic() {
        return inputTopic;
    }

    public void setInputTopic(String inputTopic) {
        this.inputTopic = inputTopic;
    }

    public int getWorkflowId() {
		return workflowId;
	}

	public void setWorkflowId(int workflowId) {
		this.workflowId = workflowId;
	}

    public List<Integer> getReviewsToBeRemoved() {
        return reviewsToBeRemoved;
    }

    public void setReviewsToBeRemoved(List<Integer> reviewsToBeRemoved) {
        this.reviewsToBeRemoved = reviewsToBeRemoved;
    }

    public List<Integer> getReviewsToBeAdded() {
        return reviewsToBeAdded;
    }

    public void setReviewsToBeAdded(List<Integer> reviewsToBeAdded) {
        this.reviewsToBeAdded = reviewsToBeAdded;
    }
}
